<?php
// widgets/Alert.php
namespace app\widgets;

use Yii;
use yii\bootstrap5\Widget;

class Alert extends Widget
{
    public function run()
    {
        $session = Yii::$app->session;
        $flashes = $session->getAllFlashes();

        foreach ($flashes as $type => $data) {
            $data = (array) $data;
            foreach ($data as $message) {
                echo \yii\bootstrap5\Alert::widget([
                    'options' => [
                        'class' => 'alert-' . $type . ' animate__animated animate__fadeInDown',
                    ],
                    'body' => $message,
                ]);
            }
            $session->removeFlash($type);
        }
    }
}