<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-register">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title text-center"><?= Html::encode($this->title) ?></h2>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'register-form',
                    ]); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'username')->textInput([
                                'maxlength' => true,
                                'placeholder' => 'Только латинские буквы и цифры'
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'email')->textInput([
                                'maxlength' => true,
                                'type' => 'email'
                            ]) ?>
                        </div>
                    </div>

                    <?= $form->field($model, 'full_name')->textInput([
                        'maxlength' => true,
                        'placeholder' => 'Иванов Иван Иванович'
                    ]) ?>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'passport_series')->widget(MaskedInput::class, [
                                'mask' => '9999',
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'passport_number')->widget(MaskedInput::class, [
                                'mask' => '999999',
                            ]) ?>
                        </div>
                    </div>

                    <?= $form->field($model, 'address')->textarea(['rows' => 3]) ?>

                    <?= $form->field($model, 'phone')->widget(MaskedInput::class, [
                        'mask' => '+7(999)-999-99-99',
                    ]) ?>

                    <?= $form->field($model, 'password_hash')->passwordInput([
                        'minlength' => 7,
                        'placeholder' => 'Минимум 7 символов'
                    ]) ?>

                    <div class="form-group">
                        <?= Html::submitButton('Зарегистрироваться', [
                            'class' => 'btn btn-primary w-100',
                            'name' => 'register-button'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <div class="text-center mt-3">
                        <p>Уже есть аккаунт? <?= Html::a('Войти', ['site/login']) ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>