<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\helpers\ArrayHelper;

$this->title = 'Новая заявка на бронирование';
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="booking-create">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title"><?= Html::encode($this->title) ?></h2>
        </div>
        <div class="card-body">
            <?php $form = ActiveForm::begin([
                'id' => 'booking-form',
            ]); ?>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'room_type_id')->dropDownList(
                        ArrayHelper::map($roomTypes, 'id', 'name'),
                        ['prompt' => 'Выберите тип номера']
                    ) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'payment_method')->dropDownList([
                        'cash' => 'Наличные',
                        'card' => 'Банковская карта'
                    ], ['prompt' => 'Выберите способ оплаты']) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'check_in_date')->textInput(['type' => 'date']) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'check_out_date')->textInput(['type' => 'date']) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'adults_count')->textInput(['type' => 'number', 'min' => 1]) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'children_count')->textInput(['type' => 'number', 'min' => 0]) ?>
                </div>
            </div>

            <?= $form->field($model, 'additional_services')->textarea([
                'rows' => 3,
                'placeholder' => 'Опишите дополнительные услуги, если требуется...'
            ]) ?>

            <div class="form-group">
                <?= Html::submitButton('Создать заявку', [
                    'class' => 'btn btn-success btn-lg w-100',
                    'name' => 'create-booking-button'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>