<?php
use yii\helpers\Html;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Управление заявками', 'url' => ['bookings']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-view-booking">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title"><?= Html::encode($this->title) ?></h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h5>Информация о заявке</h5>
                    <p><strong>Пользователь:</strong> <?= Html::encode($model->user->full_name) ?></p>
                    <p><strong>Email:</strong> <?= Html::encode($model->user->email) ?></p>
                    <p><strong>Телефон:</strong> <?= Html::encode($model->user->phone) ?></p>
                    <p><strong>Тип номера:</strong> <?= Html::encode($model->roomType->name) ?></p>
                    <p><strong>Даты:</strong> <?= Yii::$app->formatter->asDate($model->check_in_date) ?> - <?= Yii::$app->formatter->asDate($model->check_out_date) ?></p>
                </div>
                <div class="col-md-6">
                    <h5>Детали бронирования</h5>
                    <p><strong>Взрослые:</strong> <?= $model->adults_count ?></p>
                    <p><strong>Дети:</strong> <?= $model->children_count ?></p>
                    <p><strong>Дополнительные услуги:</strong> <?= $model->additional_services ? nl2br(Html::encode($model->additional_services)) : 'Не указаны' ?></p>
                    <p><strong>Способ оплаты:</strong> <?= $model->payment_method == 'cash' ? 'Наличные' : 'Банковская карта' ?></p>
                    <p><strong>Сумма:</strong> <?= Yii::$app->formatter->asCurrency($model->total_amount) ?></p>
                    <p><strong>Статус:</strong> <span class="badge bg-<?= $model->status === 'new' ? 'primary' : ($model->status === 'completed' ? 'success' : 'warning') ?>"><?= $model->getStatusLabel() ?></span></p>
                </div>
            </div>
            <div class="mt-4">
                <?= Html::a('Редактировать', ['update-booking', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                <?= Html::a('Вернуться к списку', ['bookings'], ['class' => 'btn btn-secondary']) ?>
            </div>
        </div>
    </div>
</div>