<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Типы номеров';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-room-types">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
    </div>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            'name',
            [
                'attribute' => 'price_per_night',
                'format' => 'currency',
            ],
            'max_guests',
            'bed_type',
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
            ],
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{update}',
                'buttons' => [
                    'update' => function ($url, $model) {
                        return Html::a('<i class="fas fa-edit"></i>', $url, [
                            'class' => 'btn btn-sm btn-outline-secondary',
                            'title' => 'Редактировать',
                        ]);
                    },
                ],
            ],
        ],
    ]); ?>
</div>