<?php
// models/Review.php
namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName()
    {
        return 'reviews';
    }

    public function rules()
    {
        return [
            [['user_id', 'rating', 'comment'], 'required'],
            [['user_id', 'booking_id', 'rating'], 'integer'],
            [['comment'], 'string'],
            [['rating'], 'in', 'range' => [1, 2, 3, 4, 5]],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'Пользователь',
            'booking_id' => 'Бронирование',
            'rating' => 'Рейтинг',
            'comment' => 'Комментарий',
            'created_at' => 'Создан',
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getBooking()
    {
        return $this->hasOne(Booking::class, ['id' => 'booking_id']);
    }
}