<?php
use yii\db\Migration;

class m251026_192109_create_reviews_table extends Migration
{
    public function up()
    {
        $this->createTable('reviews', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'booking_id' => $this->integer(),
            'rating' => $this->integer()->notNull(), // 1-5
            'comment' => $this->text()->notNull(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-reviews-user_id',
            'reviews',
            'user_id',
            'users',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-reviews-booking_id',
            'reviews',
            'booking_id',
            'bookings',
            'id',
            'SET NULL'
        );
    }

    public function down()
    {
        $this->dropForeignKey('fk-reviews-user_id', 'reviews');
        $this->dropForeignKey('fk-reviews-booking_id', 'reviews');
        $this->dropTable('reviews');
    }
}