<?php
use yii\db\Migration;

class m251026_192101_create_bookings_table extends Migration
{
    public function up()
    {
        $this->createTable('bookings', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'room_type_id' => $this->integer()->notNull(),
            'check_in_date' => $this->date()->notNull(),
            'check_out_date' => $this->date()->notNull(),
            'adults_count' => $this->integer()->notNull(),
            'children_count' => $this->integer()->defaultValue(0),
            'additional_services' => $this->text(),
            'payment_method' => $this->string(20)->notNull(), // 'cash' or 'card'
            'status' => $this->string(20)->defaultValue('new'), // 'new', 'in_process', 'completed', 'cancelled'
            'total_amount' => $this->decimal(10,2),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-bookings-user_id',
            'bookings',
            'user_id',
            'users',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-bookings-room_type_id',
            'bookings',
            'room_type_id',
            'room_types',
            'id',
            'CASCADE'
        );
    }

    public function down()
    {
        $this->dropForeignKey('fk-bookings-user_id', 'bookings');
        $this->dropForeignKey('fk-bookings-room_type_id', 'bookings');
        $this->dropTable('bookings');
    }
}