<?php
use yii\db\Migration;

class m251026_192052_create_room_types_table extends Migration
{
    public function up()
    {
        $this->createTable('room_types', [
            'id' => $this->primaryKey(),
            'name' => $this->string(100)->notNull(),
            'description' => $this->text(),
            'price_per_night' => $this->decimal(10,2)->notNull(),
            'max_guests' => $this->integer()->notNull(),
            'bed_type' => $this->string(50),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        // Добавляем основные типы номеров
        $this->batchInsert('room_types',
            ['name', 'description', 'price_per_night', 'max_guests', 'bed_type'],
            [
                ['Стандарт (одноместный с односпальной кроватью)', 'Комфортабельный номер с односпальной кроватью', 2500.00, 1, 'односпальная'],
                ['Стандарт (одноместный с двуспальной кроватью)', 'Просторный номер с двуспальной кроватью', 3000.00, 1, 'двуспальная'],
                ['Стандарт с двумя односпальными кроватями', 'Идеальный номер для друзей или коллег', 3500.00, 2, 'две односпальные'],
                ['Люкс одноместный', 'Роскошный номер с улучшенной отделкой', 5000.00, 1, 'двуспальная'],
                ['Люкс двуместный', 'Просторный люкс для комфортного отдыха', 7000.00, 2, 'двуспальная'],
            ]
        );
    }

    public function down()
    {
        $this->dropTable('room_types');
    }
}