<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Review;
use app\models\Booking;

class ReviewController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionCreate($booking_id = null)
    {
        $model = new Review();
        $model->user_id = Yii::$app->user->id;

        if ($booking_id) {
            $booking = Booking::find()
                ->where(['id' => $booking_id, 'user_id' => Yii::$app->user->id])
                ->one();
            if ($booking) {
                $model->booking_id = $booking_id;
            }
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Отзыв успешно добавлен.');
            return $this->redirect(['booking/index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }
}