<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Booking;
use app\models\RoomType;
use yii\web\NotFoundHttpException;

class BookingController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $bookings = Booking::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->with(['roomType'])
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('index', [
            'bookings' => $bookings,
        ]);
    }

    public function actionCreate($room_type_id = null)
    {
        $model = new Booking();
        $model->user_id = Yii::$app->user->id;

        if ($room_type_id) {
            $model->room_type_id = $room_type_id;
        }

        $roomTypes = RoomType::find()->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Заявка на бронирование успешно создана!');
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'roomTypes' => $roomTypes,
        ]);
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);

        if ($model->user_id !== Yii::$app->user->id) {
            throw new NotFoundHttpException('Заявка не найдена.');
        }

        return $this->render('view', [
            'model' => $model,
        ]);
    }

    protected function findModel($id)
    {
        if (($model = Booking::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('Заявка не найдена.');
    }
}